---
title: Overview · Cloudflare Billing docs
description: Manage billing and subscriptions for your account.
lastUpdated: 2025-09-03T15:11:54.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/billing/
  md: https://developers.cloudflare.com/billing/index.md
---

Welcome to the Cloudflare Billing and Payment Help Center! Here you will find answers to some of the most common and impactful issues facing our customers today. Most current issues revolve around:

* Payment failures
* Outstanding balances
* Subscription renewals
* Cancellation requests
* Updating payment methods
* Understanding billing cycles

An overview of these issues can be found below:

## Failed Plan Modifications

You may receive an error when attempting to purchase a product, pay a balance or change a paid plan. Review the following guides for possible solutions:

* [Resolve a payment failure](https://developers.cloudflare.com/billing/troubleshoot-failed-payments/)
* [Resolve the zone cannot be upgraded error](https://developers.cloudflare.com/billing/resolve-zone-cannot-be-ugpraded/)
* [Resolve "You cannot modify this subscription"](https://developers.cloudflare.com/billing/resolve-you-cannot-modify-this-subscription/)

If the problems above do not apply to you, there are intermittent issues with subscription upgrades, downgrades, and cancellations. This may result in billing charges being applied without the subscription level being updated. In these instances, you should [contact support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).

## Cannot update or remove payment methods

You should be able to add, update, and remove payment methods in your account. If you are seeing difficulties doing this, refer to the following guides for possible solutions:

* [Update billing information](https://developers.cloudflare.com/billing/update-billing-info/)
* [Resolve "Cannot remove payment method"](https://developers.cloudflare.com/billing/resolve-cannot-remove-payment-method/)

If the solutions above do not apply to you, we have observed reports of being unable to update or add payment methods within the dashboard. In these instances, you should [contact support](https://developers.cloudflare.com/support/contacting-cloudflare-support/).

## Cancellations

Cancellations are not processed until the end of the billing period. To understand more, refer to [Cancel Cloudflare subscriptions](https://developers.cloudflare.com/billing/cancel-subscription/).

## Non-refundable occurrences

In accordance with the Cloudflare Billing Policy, be aware that some [Non-Refundable occurrences](https://developers.cloudflare.com/billing/billing-policy/#non-refundable-occurrences) cannot be refunded and you should not contact support to request refunds for these.
