---
title: Pause Cloudflare · Cloudflare Fundamentals docs
description: To troubleshoot your site, you can pause Cloudflare globally. This
  will send traffic directly to your origin web server instead of Cloudflare's
  reverse proxy. Paused domains also cannot use Cloudflare services like Rules,
  WAF, and SSL/TLS certificates. Consider turning on Development Mode to bypass
  caching while preserving protection.
lastUpdated: 2025-09-15T16:24:30.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/manage-domains/pause-cloudflare/
  md: https://developers.cloudflare.com/fundamentals/manage-domains/pause-cloudflare/index.md
---

To troubleshoot your site, you can pause Cloudflare globally. This will send traffic directly to your origin web server instead of Cloudflare's reverse proxy. Paused domains also cannot use Cloudflare services like [Rules](https://developers.cloudflare.com/rules/), [WAF](https://developers.cloudflare.com/waf/), and [SSL/TLS certificates](https://developers.cloudflare.com/ssl/edge-certificates/). Consider turning on [Development Mode](https://developers.cloudflare.com/fundamentals/manage-domains/pause-cloudflare/#enable-development-mode) to bypass caching while preserving protection.

1. In the Cloudflare dashboard, go to the **Account home** page and select your account and domain.

   [Go to **Account home**](https://dash.cloudflare.com/?to=/:account/home)

2. Within **Overview**, choose **Advanced Actions** > **Pause Cloudflare on Site**.

The process of pausing Cloudflare takes five minutes or less. This approach is preferable to [changing nameservers](https://developers.cloudflare.com/dns/zone-setups/full-setup/setup/), which can cause propagation delays of several hours.

***

## Alternatives to global pause

### Disable proxy on DNS records

Instead of pausing Cloudflare globally, you can disable the proxy on individual records:

1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and select your account and domain.

2. Go to **DNS** > **Records**. Choose the record and select **Edit**.

3. Toggle **Proxy Status** to **Off**.

Adjusting the proxy status will prevent that record from using Cloudflare services like [Rules](https://developers.cloudflare.com/rules/), [WAF](https://developers.cloudflare.com/waf/), and [SSL/TLS certificates](https://developers.cloudflare.com/ssl/edge-certificates/).

### Enable Development Mode

To troubleshoot caching issues, you could [enable Development Mode](https://developers.cloudflare.com/cache/reference/development-mode/). This will bypass Cloudflare's cache while still preserving Cloudflare services like [Rules](https://developers.cloudflare.com/rules/), [WAF](https://developers.cloudflare.com/waf/), and [SSL/TLS certificates](https://developers.cloudflare.com/ssl/edge-certificates/).
