---
title: Add a response header with a static value · Cloudflare Rules docs
description: Create a response header transform rule to add a `set-cookie` HTTP
  header to the response with a static value (`cookiename=value`).
lastUpdated: 2025-10-13T13:40:40.000Z
chatbotDeprioritize: false
tags: Response modification
source_url:
  html: https://developers.cloudflare.com/rules/transform/examples/add-response-header-static-value/
  md: https://developers.cloudflare.com/rules/transform/examples/add-response-header-static-value/index.md
---

The following response header transform rule adds a header named `set-cookie` with a static value (`cookiename=value`) to the HTTP response:

Text in **Expression Editor**:

```txt
starts_with(http.request.uri.path, "/en/")
```

Selected operation under **Modify response header**: *Add*

**Header name**: `set-cookie`

**Value**: `cookiename=value`

This rule would keep any existing `set-cookie` headers already present in the HTTP response.
