---
title: Product changelog · Cloudflare Style Guide
description: This component can be used to display entries from the changelog
  for a given product or product area.
lastUpdated: 2025-08-12T17:54:27.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/product-changelog/
  md: https://developers.cloudflare.com/style-guide/components/product-changelog/index.md
---

This component can be used to display entries from the [changelog](https://developers.cloudflare.com/changelog/) for a given product or product area.

## Import

```mdx
import { ProductChangelog } from "~/components";
```

## Usage

```mdx
import { ProductChangelog } from "~/components";


<ProductChangelog product="workers" />
```

## `<ProductChangelog>` Props

The `product` and `area` props cannot be used at the same time.

### `product`

**type:** `string`

The name of the product.

### `area`

**type:** `string`

The name of the product area.

### `hideEntry`

**type:** `string`

The name of a specific entry to hide.

### `scheduled`

**type:** `boolean`

**default:** `false`

Used to only show scheduled entries (i.e for WAF changelogs).
